<?php
/*
	DevSaver Web Framework
	Copyright (c) 2002-2018 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com
*/

if (!defined("STPBase")) {
	die("This file can't be accessed directly!");
}

global $site , $_LANG_RAW;

$logos = array(
	"png"	=> array(
		"normal"	=> "upload/logo.png",
		"inverted"	=> "upload/logo.png",
	),

	"svg"	=> array(
		"normal"	=> "upload/logo.svg",
		"inverted"	=> "upload/logo.svg",
	),
);

if (file_exists("upload/logo-inv.png")) {
	$logos["png"]["inverted"]= "upload/logo-inv.png";
}

if (file_exists("upload/logo-inv.svg")) {
	$logos["svg"]["inverted"]= "upload/logo-inv.svg";
}


if ($_LANG_RAW["lang_logo"]) {
	$logos["png"]["normal"] = "upload/langs/{$_LANG_RAW[lang_id]}.png";
}

if ($_LANG_RAW["lang_logo_inv"]) {
	$logos["png"]["inverted"] = "upload/langs/{$_LANG_RAW[lang_id]}-inverted.png";
}

if ($_LANG_RAW["lang_logo_svg"]) {
	$logos["svg"]["normal"] = "upload/langs/{$_LANG_RAW[lang_id]}.svg";
}

if ($_LANG_RAW["lang_logo_svg_inv"]) {
	$logos["svg"]["inverted"] = "upload/langs/{$_LANG_RAW[lang_id]}-inverted.svg";
}

//svg
if ($site->vars->data["set_logo_type"] == "2") {
	$logos = $logos["svg"];
} else {
	$logos = $logos["png"];
}


$_TSM["PUB:LOGO"] = $logos["normal"];
$_TSM["PUB:LOGO_INVERTED"] = $logos["inverted"];


?>